<?php namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;

class LoginController extends Controller {
    
    public function __construct() {
        $this->middleware('guest:admin')->except('logout');
    }
    
    public function loginform(Request $request) {
        return view('auth.login');
    }
    
    public function login(Request $request) {
        $rules = [
            'email' => 'required',
            'password' => 'required',
        ];
        $inputs = $request->validate($rules);
        $remember = $request->get('remember');
        
        if(Auth::guard('admin')->attempt($inputs, $remember)) {
            return redirect()->route('admin-dashboard');
        } else {
            return redirect(route('admin-login'))->with('error_msg', 'Invalid Username or Password');
        }
    }
    
    public function logout(Request $request) {
        Auth::guard('admin')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('admin-login');
    }

}