<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\Admin;
use App\Models\User;
use App\Models\Role;
use Auth;

class UserController extends Controller {

    public function __construct() {
        $this->middleware('auth:admin');
    }
    public function index() {
        //$admins = '';
        //if(Auth::guard('admin')->user()->isSuper()) {
            //$admins = Admin::all();
        //} else {
            $admins = User::where('id', '!=', 1)->get();
        //}
        
        return view('admin.user.index', compact('admins'));
    }

    public function create() {
        return view('admin.user.create');
    }

    public function store(Request $request) {
        
        $rules = [
            'name' => 'required',
            'email' => 'required|unique:users',
            'phone' => 'required',
            'password' => 'required|min:6',
        ];

        $request->validate($rules);
        $inputs = $request->all();
        $inputs['name'] = ucfirst($request->name);
        $inputs['password'] = Hash::make($request->password);
        User::create($inputs);
        return redirect()->route('admin-user')->withStatus(__('User is added successfully.'));
    }

    public function edit($id) {
        $user = User::findorFail($id);
        return view('admin.user.edit', compact('user'));
    }

    public function update(Request $request, $id) {
        $pass = (function($query){
            if(!empty($query)) {
                return 'required|min:6';
            }
            return '';
        });
        $rules = [
            'name' => 'required',
            'email' => 'required|unique:users,email,'. $id,
            'password' => $pass($request->password),
        ];

        $request->validate($rules);
        $inputs = $request->all();
        $user = User::findorFail($id);
        //$inputs['name'] = ucfirst($request->name);
        if(!empty($request->password)) {
            $inputs['password'] = Hash::make($request->password);
        } else {
            $inputs['password'] = $user->password;
        }
        $user->update($inputs);
        return redirect()->route('admin-user')->withStatus(__('User is updated successfully.'));
    }

    public function destroy($id) {
        $user = User::findorFail($id);
        if(!empty($user) && $user->id != 1) {
            $user->delete();
        }
        return redirect()->route('admin-user')->withStatus(__('User is deleted successfully.'));
    }

}
