<?php
use App\Models\FilterMaster;
use App\Models\Category;
use App\Models\UserGuest;
use App\Models\Order;
use App\Models\User;
use App\Models\Coupon;
use App\Models\Product;
use App\Models\ProductSpecification;

if(!function_exists('get_categories')) {
    function get_categories() {
        return Category::active()->get();
    }
}

function get_guest($date) {
    $guest = UserGuest::whereDate('created_at',$date)->count();
    if($guest){
        return $guest;
    }
    else{
        echo "0";
    }
}
function get_customer_sale($date) {
    $customerOrder =  Order::where('user_id','!=',0)->whereDate('created_at',$date)->count();
    if($customerOrder){
        return $customerOrder;
    }
    else{
        echo "0";
    }
}
function get_signup_user($date) {
    $signup =  User::whereDate('created_at',$date)->count();
    if($signup){
        return $signup;
    }
    else{
        echo "0";
    }
}

function total_sale($date){
    $totalOrder =  Order::whereDate('created_at',$date)->count();
    if($totalOrder){
        return $totalOrder;
    }
    else{
        $totalOrder=0;
        return $totalOrder;
    }
}
function free_shipping($date){
    $countFree =0;
    $freeShipping =  Order::whereDate('created_at',$date)->where('coupon_id','!=',NULL)->get('coupon_id');
    if(count($freeShipping)>0){
        foreach($freeShipping as $coupon_id){
        
            $count = Coupon::where('id',$coupon_id->coupon_id)->where('free_shipping',1)->count();
            $countFree = $countFree+$count;
        }  
    }
    
    if($countFree>0){
        return $countFree;
    }
    else{
        $countFree=0;
        return $countFree;
    }
}

function worthCouponUsed($date){
    $couponPrice= Order::whereDate('created_at',$date)->where('coupon_id','!=',NULL)->sum('coupon_price');
    if($couponPrice>0){
        return number_format($couponPrice,2);
    }else{
        $couponPrice=0.00;
        return number_format($couponPrice,2);
    }
}

function get_productName($id){
    $productName = Product::where('id',$id)->first('name');
    if($productName){
        return $productName->name;
        
    }else{
        return false;
    }
}


function orderID($id){
    $order_id = Order::where('id',$id)->first('order_id');
    if($order_id){
        return $order_id->order_id;
        
    }else{
        return false;
    }
}

function countParentFilter($parent_id){
    $totalRecord =  FilterMaster::where('parent_id',$parent_id)->count();
    if($totalRecord){
        return $totalRecord;
    }
    else{
        $totalRecord=0;
        return $totalRecord;
    }
}


