<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Admin extends Authenticatable
{
    
    use Notifiable;
    
    protected $guard = 'admin';
    
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'role_id', 'email', 'password', 'phone', 'image', 'status',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
    
    
    public function role() {
        return $this->belongsTo('App\Models\Role');
    }

    public function hasPermission($permission) {
        $sections = explode(',', $this->role->section);
        if(in_array($permission, $sections)) {
            return true;
        } else {
            return false;
        }
    }
    
    public function isSuper() {
        if($this->id == 1) {
            return true;
        } else {
            return false;
        }
    }
    
    public function checkStatus() {
        return $this->status;
    }
    
    public function banners() {
        return $this->hasMany('App\Models\Banner');
    }
    
    public function brands() {
        return $this->hasMany('App\Models\Brand');
    }
    
}
