<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\User\LoginController;

/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | Here is where you can register web routes for your application. These
  | routes are loaded by the RouteServiceProvider within a group which
  | contains the "web" middleware group. Now create something great!
  |
 */

Route::get('/clear-cache', function() {
    Artisan::call('config:cache');
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
});            

Route::get('/', [LoginController::class, 'home'])->name('front-home');

    
Route::prefix('user/')->group(function () {
    Route::get('login', [LoginController::class, 'loginform'])->name('user-login');
    Route::post('login', [LoginController::class, 'login'])->name('user-login-submit');
    Route::get('logout', [LoginController::class, 'logout'])->name('user-logout');
});