<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRolesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $connection = config('roles.connection');
        $table = config('roles.rolesTable');
        $tableCheck = Schema::connection($connection)->hasTable($table);

        if(!Schema::hasTable($table)){
            if (!$tableCheck) {
                Schema::connection($connection)->create($table, function (Blueprint $table) {
                    $table->increments('id')->unsigned();
                    $table->string('name');
                    $table->string('slug')->unique();
                    $table->string('description')->nullable();
                    $table->integer('level')->default(1);
                    $table->timestamps();
                    $table->softDeletes();
                });
            }
        }
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $connection = config('roles.connection');
        $table = config('roles.rolesTable');
        Schema::connection($connection)->dropIfExists($table);
    }
}
