<?php use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\LoginController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\UserController;

Route::get('/login', [LoginController::class, 'loginform'])->name('admin-login');
Route::post('/login', [LoginController::class, 'login'])->name('admin-login-submit');
Route::get('/logout', [LoginController::class, 'logout'])->name('admin-logout');
Route::get('/', [DashboardController::class, 'index'])->name('admin-dashboard');

Route::get('/clear-cache', [DashboardController::class, 'clearcache'])->name('admin-dashboard-cache');

// route for users
Route::middleware('permissions:users')->group(function () {
    Route::get('user', [UserController::class, 'index'])->name('admin-user');
    Route::get('user/create', [UserController::class, 'create'])->name('admin-user-create');
    Route::post('user/store', [UserController::class, 'store'])->name('admin-user-store');
    Route::get('user/edit/{id}', [UserController::class, 'edit'])->name('admin-user-edit');
    Route::post('user/edit/{id}', [UserController::class, 'update'])->name('admin-user-update');
    Route::get('user/delete/{id}', [UserController::class, 'destroy'])->name('admin-user-destroy');
});



