<?php $__env->startSection('title', 'User'); ?>

<?php $__env->startSection('breadcrumb-title'); ?>
<h3>User</h3>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb-items'); ?>
<li class="breadcrumb-item active">User</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
   
   <div class="row">
      <div class="col-sm-12">
         <div class="card">
           <div class="card-header">          
               <div class="row">
                  <div class="col-6">
                     <h5>User</h5>
                  </div>
                  <div class="col-6 text-right">
                     <a href="<?php echo e(route('admin-user-create')); ?>"><button class="btn btn-primary"><i class="fa fa-plus mr-1"></i>New</button></a>
                  </div>
               </div>             
           </div>
           <div class="card-body">
             <div class="table-responsive">
               <table class="table data-tables" >
                  <thead class="table-light">
                     <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Email</th>                                              
                        <th>Phone</th>                                              
                        <th>Action</th>
                     </tr>
                  </thead>
                  <tbody>
                     <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($value->name); ?></td>
                        <td><?php echo e($value->email); ?></td>
                        <td><?php echo e($value->phone); ?></td>
                        <td>
                           <a href='<?php echo e(route("admin-user-edit", $value->id)); ?>' class='btn btn-primary btn-xs'> <i class="fa fa-edit"></i></a>
                           <a href='<?php echo e(route("admin-user-destroy", $value->id)); ?>' class='btn btn-primary btn-xs'> <i class="fa fa-trash"></i></a>
                        </td>
                     </tr>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
               </table>
             </div>
           </div>
         </div>
       </div>
   </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<script type="text/javascript">
    $(document).ready(function() {
   <?php if(Session::has('status')): ?>
      $.notify({ message:'<?php echo session("status"); ?>'},{
         type:'success',
         allow_dismiss:false,  
         icon: 'fa fa-check',                                          
         timer:2000,
         delay:500 ,      
         placement:{
            from:'top',
            align:'center'
         },                                      
      });   
   <?php endif; ?>
    });
 
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.light.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mix/public_html/resources/views/admin/user/index.blade.php ENDPATH**/ ?>