<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;


class LoginController extends Controller {
    
    use AuthenticatesUsers;
    
    public function __construct() {
        $this->middleware('guest:web')->except('logout');
    }
    
    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;
    
    public function home() {        
        return view('web.home');
    }
    
    public function login(Request $request) {
        $rules = [
            'phone' => 'required',
            'password' => 'required',
        ];
        $inputs = $request->validate($rules);

        if (Auth::attempt(['phone' => $request->phone,'password' => $request->password])) 
        {
            $user = User::select('form_url')->where('id',Auth::user()->id)->first();
            if($user){
                return redirect()->to($user->form_url);
            }
            else{
                Auth::guard('web')->logout();
                $request->session()->invalidate();
                $request->session()->regenerateToken();
                return redirect()->route('front-home');
            }            
        } 
        else {
            return redirect()->route('front-home')->with('error_msg', 'Invalid Username or Password');
        }
    }
    
    public function logout(Request $request) {
        Auth::guard('web')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('front-home');
    }

}