<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\OrderDetail;
use App\Models\Order;
use Carbon\Carbon;
use Auth;
use Artisan;
use DB;

class DashboardController extends Controller {
    
    public function __construct() {
        $this->middleware('auth:admin');
    }
    
    public function index(Request $request) 
    {
        if(Auth::guard('admin')->user()->isSuper())
        {
            return view('admin.back.dashboard.index');
        } 
        else
        {
            Auth::guard('admin')->logout();
            return redirect()->route('admin-login')->with('error_msg', 'This account is not active');
        }        
    }
    
    public function clearcache() {
        if(Auth::guard('admin')->user()->isSuper()) {
            //Artisan::call();
            Artisan::call('config:cache');
            Artisan::call('cache:clear');
            Artisan::call('config:clear');
            Artisan::call('view:clear');
            Artisan::call('route:clear');
            return redirect()->route('admin-dashboard')->withStatus("Cache Cleared"); 
        } else {
            return redirect()->route('admin-dashboard')->withStatus("You dont have access to that section"); 
        }
    }

}