<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string|null
     */
    protected function redirectTo($request){
        if (! $request->expectsJson()) {
            if($request->route()->getPrefix() == 'isadmin') {
                return route('admin-login');
            } else {
                return route('front-home');
            }
            //return abort(401);
            //var_dump($request->is('isadmin'));
        }
    }
}
