<?php

namespace App\Http\Middleware;
use Auth;
use Closure;

class Permissions {
    
    public function handle($request, Closure $next, $data) {
        if(Auth::guard('admin')->check()) {
            if(Auth::guard('admin')->user()->isSuper()){
                return $next($request);
            }
            if(Auth::guard('admin')->user()->role_id == 0){
                return redirect()->route('admin-dashboard')->withStatus("You dont have access to that section"); 
            }
            if (Auth::guard('admin')->user()->hasPermission($data)){
                if(Auth::guard('admin')->user()->checkStatus()) {
                    return $next($request);
                } else {
                    Auth::guard('admin')->logout();
                    $request->session()->invalidate();
                    $request->session()->regenerateToken();
                    return redirect()->route('admin-login')->with('error_msg', 'This account is not active');
                }
            }
            return redirect()->route('admin-dashboard')->withStatus("You dont have access to that section"); 
        }
        return redirect()->route('admin-dashboard')->withStatus("You dont have access to that section"); 
    }
    
}
