@extends('admin.layouts.light.master')
@section('title', 'Edit User')


@section('breadcrumb-title')
<h3>User</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">User</li>
<li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
          <div class="card">
            <div class="card-body">
              <form method="post" action="{{route('admin-user-update', $user->id)}}" class="form theme-form">
                @csrf
                <div class="row">
                  <div class="col-6">
                    <div class="form-group">
                        <label class="col-form-label">Name</label>
                        <input class="form-control" type="text" value="{{ $user->name }}" name="name" placeholder="Enter Name">
                        @error('name')
                        <div class="text-danger show"><strong>{{$message}}</strong></div>
                        @enderror
                    </div>
                  </div>
                  <div class="col-6">
                    <div class="form-group mb-3">
                      <label class="col-form-label">Email</label>
                      <input class="form-control" type="email" value="{{ $user->email }}" name="email" placeholder="Enter Email">
                      @error('email')
                      <div class="text-danger show"><strong>{{$message}}</strong></div>
                      @enderror
                    </div>
                  </div>
                </div>
                
                <div class="row">
                  <div class="col-6">
                    <div class="form-group">
                        <label class="col-form-label">Phone</label>
                        <input class="form-control" type="number" value="{{ $user->phone }}" name="phone" placeholder="Enter Phone">
                        @error('phone')
                        <div class="text-danger show"><strong>{{$message}}</strong></div>
                        @enderror
                    </div>
                  </div>
                  <div class="col-6">
                    <div class="form-group mb-3">
                      <label class="col-form-label">Password</label>
                      <input class="form-control" type="password" value="" name="password" placeholder="******">
                      <!--<div class="show-hide"><span class="show"> </span></div>-->
                      @error('password')
                      <div class="text-danger show"><strong>{{$message}}</strong></div>
                      @enderror
                    </div>
                  </div>                 
                </div> 

                <div class="row">          
                  <div class="col-6">
                    <div class="form-group mb-3">
                      <label class="col-form-label">Form URL</label>
                      <input class="form-control" type="url" value="{{ $user->form_url }}" name="form_url" placeholder="Enter URL">
                      @error('url')
                      <div class="text-danger show"><strong>{{$message}}</strong></div>
                      @enderror
                    </div>
                  </div>                
                </div> 
                
                <div class="row">
                  <div class="col-12">
                    <div>
                      <button type="submit" class="btn btn-primary me-3">Update</button>
                      <a href="{{route('admin-user')}}"><button type="button" class="btn btn-danger">Cancel</button></a>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
    </div>
</div>
@endsection

@section('script')
@endsection