@extends('admin.layouts.light.master')
@section('title', 'User')

@section('breadcrumb-title')
<h3>User</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item active">User</li>
@endsection

@section('content')
<div class="container-fluid">
   
   <div class="row">
      <div class="col-sm-12">
         <div class="card">
           <div class="card-header">          
               <div class="row">
                  <div class="col-6">
                     <h5>User</h5>
                  </div>
                  <div class="col-6 text-right">
                     <a href="{{route('admin-user-create')}}"><button class="btn btn-primary"><i class="fa fa-plus mr-1"></i>New</button></a>
                  </div>
               </div>             
           </div>
           <div class="card-body">
             <div class="table-responsive">
               <table class="table data-tables" >
                  <thead class="table-light">
                     <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Email</th>                                              
                        <th>Phone</th>                                              
                        <th>Action</th>
                     </tr>
                  </thead>
                  <tbody>
                     @foreach ($admins as $value)
                     <tr>
                        <td>{{$loop->iteration}}</td>
                        <td>{{$value->name}}</td>
                        <td>{{$value->email}}</td>
                        <td>{{$value->phone}}</td>
                        <td>
                           <a href='{{route("admin-user-edit", $value->id)}}' class='btn btn-primary btn-xs'> <i class="fa fa-edit"></i></a>
                           <a href='{{route("admin-user-destroy", $value->id)}}' class='btn btn-primary btn-xs'> <i class="fa fa-trash"></i></a>
                        </td>
                     </tr>
                     @endforeach
                  </tbody>
               </table>
             </div>
           </div>
         </div>
       </div>
   </div>
</div>
@endsection

@section('script')

<script type="text/javascript">
    $(document).ready(function() {
   @if (Session::has('status'))
      $.notify({ message:'{!! session("status") !!}'},{
         type:'success',
         allow_dismiss:false,  
         icon: 'fa fa-check',                                          
         timer:2000,
         delay:500 ,      
         placement:{
            from:'top',
            align:'center'
         },                                      
      });   
   @endif
    });
 
</script>
@endsection