@extends('admin.layouts.authentication.master')
@section('title', 'Login')

@section('css')
@endsection

@section('style')
@endsection


@section('content')
<div class="container-fluid" style="background-image: url('public/assets/1.jpg');">
   <div class="row">
      <div class="col-12">
         <div class="login-card">
            <div>
               <div class="login-main">
                  <form class="theme-form needs-validation" novalidate="" method="post" action="{{route('user-login-submit')}}">
                    @csrf
                     <h4>Sign in to account</h4>
                     <p>Enter your Phone No & Password to login</p>
                     <div class="form-group">
                        <label class="col-form-label">Phone No.</label>
                        <input class="form-control" name="phone" type="text" value="{{old('phone')}}" required placeholder="Enter Phone">
                        <div class="invalid-feedback text-danger">Please Enter Phone No.</div>
                     </div>
                     <div class="form-group">
                        <label class="col-form-label">Password</label>
                        <input class="form-control" type="password" name="password" required placeholder="Enter Password">
                        <div class="invalid-feedback text-danger">Please Enter Password.</div>
                        @if(Session::has('error_msg'))                            
                            <div class="text-danger show"><strong>{{Session::get('error_msg')}}</strong></div>
                        @endif
                     </div>
                     <div class="form-group mb-0">
                        <button class="btn btn-primary btn-block" type="submit">Sign in</button>
                     </div>                   
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
@endsection
<script>
    (function() {
    'use strict';
    window.addEventListener('load', function() {
    // Fetch all the forms we want to apply custom Bootstrap validation styles to
    var forms = document.getElementsByClassName('needs-validation');
    // Loop over them and prevent submission
    var validation = Array.prototype.filter.call(forms, function(form) {
    form.addEventListener('submit', function(event) {
    if (form.checkValidity() === false) {
    event.preventDefault();
    event.stopPropagation();
    }
    form.classList.add('was-validated');
    }, false);
    });
    }, false);
    })();
    
 </script>
@section('script')
@endsection
